<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
        <!-- Basic -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">

		

		<!-- Favicon -->
		<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/img/favicon.ico" type="image/x-icon" />
		<link rel="apple-touch-icon" href="<?php echo get_template_directory_uri(); ?>/img/apple-touch-icon.png">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Web Fonts  -->
		<link id="googleFonts" href="https://fonts.googleapis.com/css?family=family=Lora:400,400i,700,700i|Poppins:300,400,500,600,700,800,900&display=swap" rel="stylesheet" type="text/css">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/animate/animate.compat.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/vendor/magnific-popup/magnific-popup.min.css">

		<!-- Theme CSS -->
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/theme.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/theme-elements.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/theme-blog.css">
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/theme-shop.css">

		<!-- Demo CSS -->
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/demos/demo-it-services.css">

		<!-- Skin CSS -->
		<link id="skinCSS" rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/skins/skin-it-services.css">
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/custom.css">

        <!--<script src="./add_header.js"></script>
        <script src="./add_footer.js"></script>-->
		<?php wp_head(); ?>
		
	</head>
	<body>

		<div class="body">

			<div id="header">
            <header id="header" class="header-effect-shrink" data-plugin-options="{'stickyEnabled': true, 'stickyEffect': 'shrink', 'stickyEnableOnBoxed': true, 'stickyEnableOnMobile': false, 'stickyChangeLogo': true, 'stickyStartAt': 120, 'stickyHeaderContainerHeight': 90}">
    <div class="header-body border-top-0 box-shadow-none">
        <div class="header-container container container-xl-custom">
            <div class="header-row">
                <div class="header-column">
                    <div class="header-row">
                        <div class="header-logo">
                            <a href="<?php echo home_url();?>">
                                <img alt="logo" src="<?php echo get_template_directory_uri(); ?>/images/logo.png">
                            </a>
                        </div>
                    </div>
                </div>
                <div class="header-column justify-content-end">
                    <div class="header-row">
                        <div class="header-nav header-nav-line header-nav-bottom-line header-nav-bottom-line-effect-1 order-2 order-lg-1">
                            <div class="header-nav-main header-nav-main-square header-nav-main-dropdown-no-borders header-nav-main-effect-2 header-nav-main-sub-effect-1">
                           <nav class="collapse">
						    <?php
							wp_nav_menu(
							array(
							'theme_location'  => 'primary',
							'menu_class'      => 'nav nav-pills',
							'menu_id'=> 'mainNav',
							'container' => '',
							'container_class' => '',
							)
							);
							?>
                            </nav>

						   
                            </div>
                            <button class="btn header-btn-collapse-nav" data-bs-toggle="collapse" data-bs-target=".header-nav-main nav">
                                <i class="fas fa-bars"></i>
                            </button>
                        </div>
                        <div class="d-none d-sm-inline-flex order-1 order-lg-2 ms-2">
                            <ul class="header-extra-info d-flex">
                                <li class="d-none d-xl-flex flex-column">
                                    <span class="d-block font-weight-semibold text-color-dark text-2 line-height-3">CONTACT</span>
                                    <?php echo the_field('contact',7); ?>
                                </li>
                                <li class="d-flex flex-column">
                                    <span class="d-block font-weight-semibold text-color-dark text-2 line-height-3">EMAIL</span>
                                    <a href="mailto:<?php echo the_field('email',7); ?>" class="font-weight-bold text-color-primary text-2-3"><?php echo the_field('email',7); ?></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
</div>